/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xutil.h
 *
 * This file contains #defines and prototypes of OS-dependent
 * functions for the sake of CAPI-portability.
 * Adapt these for your own needs/OS.
 * -----------------------------------------------------------------*/

#ifndef XUTIL_H_INCLUDED
#define XUTIL_H_INCLUDED

#include <stddef.h>
#include <stdlib.h>  /* free function is in here */

#include <xdefines.h> /* necessary for #define EXPORT used in DOSW32 */

#ifdef DOSW32
#include <malloc.h>
#else
#include <memory.h>
#if defined(WIN32) || defined(WIN64)
#include <windows.h>
#endif
#endif

/* make sure this also runs in C++ programs */
#ifdef __cplusplus
extern "C" {
#endif

/********************************************************************
 memory *************************************************************
********************************************************************/
#define BESTX_MEMCPY memcpy
#define BESTX_MEMSET memset

/********************************************************************
 string *************************************************************
********************************************************************/
#define BESTX_STRCMP     strcmp
#define BESTX_STRNCMP    strncmp
#define BESTX_STRCASECMP strcasecmp
#define BESTX_STRTOUL    strtoul
#define BESTX_WSPRINTF   wsprintf
#define BESTX_SPRINTF    sprintf
#define BESTX_STRLEN     strlen
#define BESTX_STRCAT     strcat
#define BESTX_STRCPY     strcpy
#define BESTX_STRNCPY    strncpy
#define BESTX_STRSTR     strstr

/********************************************************************
 IO *****************************************************************
********************************************************************/
#define BESTX_FOPEN     fopen
#define BESTX_FCLOSE    fclose
#define BESTX_FPRINTF   fprintf
#define BESTX_PRINTF    printf
#define BESTX_FREAD     fread

/********************************************************************
 MISC ***************************************************************
********************************************************************/
#if defined(WIN32) || defined(WIN64)
#define BESTX_SLEEP     Sleep
#elif defined (DOSW32)
#define BESTX_SLEEP     delay
#elif defined (LINUX)
#define BESTX_SLEEP(x)     usleep(x*1000)
#elif defined (UNIX)
#define BESTX_SLEEP(x) sleep(x)
#endif

/********************************************************************
  Memory allocation *************************************************
********************************************************************/

#define BestXFree(p)  free(p);
void EXPORT BestXMemFree(void ** memptr);
void EXPORT * BestXMemCalloc  (size_t num, size_t size);
void EXPORT * BestXMemRealloc (void *memptr, size_t size);
void EXPORT * BestXMemMalloc  (size_t size);

#ifdef __cplusplus
}
#endif

/* ----- Do not add code below this line ----- */
#endif /* defined XUTIL_H_INCLUDED */
